<?xml version="1.0" encoding="utf-8" ?> 

<xsl:stylesheet version='1.0' xmlns:xsl='http://www.w3.org/1999/XSL/Transform' xmlns:HTML='http://www.w3.org/Profiles/XHTML-transitional' xmlns:dt='urn:schemas-microsoft-com:datatypes'>

	<xsl:output method='html'/>



	<!-- <xsl:template match='@* | node()'>

		<xsl:copy><xsl:apply-templates select="@* | node()"/></xsl:copy>

	</xsl:template> -->

	

	<xsl:strip-space elements="*"/>

	

	<xsl:template match="dock | tabs | main">

		<xsl:if test='item or not(rows)'><xsl:call-template name='Tab'>

			<xsl:with-param name='width' select='"%100"'/>

		</xsl:call-template></xsl:if>

		<xsl:apply-templates select='rows'/>

	</xsl:template>

	

	<xsl:template match='rows'>

		<table cellpadding='0' cellspacing='0' border='0' class='TabRowTable' width='100%'>

			<tr tabRowHeight='@height'><td class='TabRowTD'>

			<table cellpadding='0' cellspacing='0' border='0' class='TabColTable'>

			<tr><xsl:apply-templates/></tr></table></td></tr>

		</table>

	</xsl:template>



	<xsl:template match='col'>

		<xsl:if test='item'><td><xsl:call-template name='Tab'>

			<xsl:with-param name='width' select='@width'/>

		</xsl:call-template></td></xsl:if>

	</xsl:template>



	<xsl:template name="Tab">

		<xsl:choose>

			<xsl:when test='not(@position)'>

		<div class='tabView'>

		<div class="tabs">

		<table cellpadding="0" cellspacing="0" width="100%" border='0' style='table-layout:fixed'>

			<xsl:if test='not(@wizard)'><colgroup><col/><col width='50px'/></colgroup></xsl:if>

			<tr>

				<td width='100%' align='left'><div class='tabItems'><table cellpadding="0" cellspacing="0" border='0'><tr><td class='tabsSpace'>&#160;</td></tr></table></div></td>

				<xsl:if test='not(@wizard)'>

				<td class='tabsScrollbar' align='right' nowrap=''>

				<img border='0' cmdid='0' src1='../apt/images/scrollleft.gif' src='../apt/images/scrollleft-disabled.gif' height='12' width='12'/>

				<img border='0' cmdid='1' src1='../apt/images/scrollright.gif' src='../apt/images/scrollright-disabled.gif' height='12' width='12'/>

				<img border='0' cmdid='2' src='../apt/images/close.gif' height='12' width='12'/>

				</td></xsl:if>

			</tr>

		</table>

		</div>

		<div class="tabContent">

			<xsl:for-each select='item'>

				<div style="display:none;width:100%;height:100%" viewURL="{@viewURL}" docPos='{position() - 1}'/>

			</xsl:for-each>

		</div>

		</div>

			</xsl:when>

			<xsl:otherwise>

				<div class='tabDock'>

					<div class='tabTitleBar'>

						<table cellpadding="0" cellspacing="0" width="100%" border='0'>

							<tr>

								<td width='99%' noWrap='true'><div class='tabTitle'></div></td>

								<td class='tabsScrollbar'>

									<img border='0' cmdid='2' src='../apt/images/close.gif' height='12' width='12'/>

								</td>

							</tr>

						</table>

					</div>

					<div class="tabContent">

						<xsl:for-each select='item'>

							<div style="display:none;width:100%;height:100%" viewURL="{@viewURL}" docPos='{position() - 1}'/>

						</xsl:for-each>

					</div>

					<div class="docTabs"><table cellpadding="0" cellspacing="0" border='0'><tr><td class='tabsSpace'>&#160;</td></tr></table></div>

				</div>

			</xsl:otherwise>

		</xsl:choose>

	</xsl:template>



</xsl:stylesheet>

